package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "generateEmailValidator")
public class GenerateEmailValidator implements Validator {

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String targetEmail = null;

		HtmlInputText targetEmailValue = (HtmlInputText) component.getAttributes().get("targetEmail");

		if (targetEmailValue != null && targetEmailValue.getValue() != null) {
			targetEmail = (String) targetEmailValue.getValue();
		}

		// fail validation if certain conditions are not met
		if (null == targetEmail || targetEmail.isEmpty()) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("generateSendEmailToFieldEmpty"), ""));
		}

	}

}
